// #####################################################################  
// ### Author: stelerp , stelerp@seznam.cz , trainzpedro.idisk.cz    ###
// ### Don't modified or used in another objects                     ###
// ### Only for CsTT community                                       ###
// ### ODJEZD                                                        ###
// ##################################################################### 

include "World.gs"

class csttCross isclass MapObject
{
  thread void FlashControl();
  //void TestCrossingState(Message msg);
  bool bWarning, bSafe, bSound;
  Asset coronaRed, coronaWhite;  
  string sCrossName;
  
  public void Init()
  {
    coronaRed = GetAsset().FindAsset("red");
    coronaWhite = GetAsset().FindAsset("white");
    AddHandler (me, "Cross-PostState", "", "TestCrossingState");
    FlashControl();  
  }
    
  void TestCrossingState(Message msg)
  {
    MapObject mp = msg.src;
    if (mp.GetName()==sCrossName) {if (msg.minor=="Enter") {bWarning=true;} else {bWarning=false;}}
  }
  
  thread void FlashControl()
  {
    int counter = 0;
    Asset meAsset = GetAsset();
    while (1)
    {
      if (bWarning or sCrossName=="")
      {
        SetFXCoronaTexture ("light-ok" , null);
        if (counter == 0)
        {
          if (!bSound){World.PlaySound(meAsset, "azd.wav", 100, 10, 200, me, "");}
          SetFXCoronaTexture ("light0" , coronaRed);
          SetFXCoronaTexture ("light1" , null);
        }
        else
        {
          SetFXCoronaTexture ("light0" , null);
          SetFXCoronaTexture ("light1" , coronaRed);
        }
      }  
      else
      {
        SetFXCoronaTexture ("light0" , null);
        SetFXCoronaTexture ("light1" , null);
        if (bSafe){SetFXCoronaTexture ("light-ok" , coronaWhite);} else {SetFXCoronaTexture ("light-ok" , null);}
      }
      Sleep(0.5);
      counter = (counter+1) % 2;
    }
  }

// ###################################################šš
  // Vlastnosti 
  // nacist promenne ze session
  public void SetProperties(Soup db)
  {
    sCrossName = db.GetNamedTag("Cross.Name");
    bSafe = db.GetNamedTagAsBool("Cross.Safe");
    bSound = db.GetNamedTagAsBool("Cross.Sound");
  }
  
  // ulozit promenne do session
  public Soup GetProperties(void)
  {
    Soup db=Constructors.NewSoup();
    // Nazvy vyhybek
    if (sCrossName) db.SetNamedTag("Cross.Name",sCrossName);
    if (bSafe) db.SetNamedTag("Cross.Safe",bSafe);
    if (bSound) db.SetNamedTag("Cross.Sound",bSound);
    return db;
  }
  
  // #############################################################š
  // HTML Dialog
  public string GetDescriptionHTML(void)
  {
    //string altName = BrowserInterface.Quote(sCrossName);
    string html,sLink;
    sLink=sCrossName;
    if (!cast<MapObject>Router.GetGameObject(sLink)) {sLink="Zadej";}
    html="<html><body>";
    html=html+"<table bgcolor=#C3CDD7 width=100% border=2><tr><td><img src=logo.bmp></td></tr></table>";
    html=html+"<table bgcolor=#C0C0C0 width=100% border=2><tr><td bgcolor=#C3CDD7><font color=#000000>Přiřadit k přejezdu: </font></td><td bgcolor=#C3CDD7><font color=#800000><a href=live://property/name>"+sLink+"</a></font></td></td><td bgcolor=#C3CDD7 width=12><a tooltip='Vynuluje nastavení pro tuto výhybku' href=live://property/reset><img src=delete.bmp mouseover=delete_r.bmp></a></td></tr></table>";
    html=html+"<table bgcolor=#C0C0C0 width=100%><tr><td bgcolor=#C3CDD7><font color=#800000>" + HTMLWindow.CheckBox("live://property/safe", bSafe) + "Používat bílé světlo pozitivní signalizace</font></td></tr></table>";
    html=html+"<table bgcolor=#C0C0C0 width=100%><tr><td bgcolor=#C3CDD7><font color=#800000>" + HTMLWindow.CheckBox("live://property/sound", bSound) + "Vypnout zvuk (Stačí pouze jeden zdroj zvuku na přejezd!)</font></td></tr></table>";
    html=html+"</body></html>";
    return html;
 }

  // Navratova hodnota vybrane vyhybky v seznamu
  public void SetPropertyValue(string propertyID , string value)
  {
    if (propertyID=="name") {sCrossName=value;}
  }
  
  public void LinkPropertyValue(string propertyID) 
  {
    if (propertyID=="reset") {sCrossName="";}
    if (propertyID=="safe") {bSafe=!bSafe;}  
    if (propertyID=="sound") {bSound=!bSound;}  
  }
  
  // Typ promene pod odkazem, zde seznam 
  string GetPropertyType(string propertyID)
  {
		  string sRet;
		  if (propertyID=="name") {sRet="string,0,64";}
		  else {sRet="link";}
      return sRet;
	}
	
	// Nadpis dialogu pro vyber vyhybky
	public string GetPropertyName(string propertyID)
  {
		return "Zadej přesný název přejezdu";
	}
};




